% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.reproFitTT.R
\name{print.reproFitTT}
\alias{print.reproFitTT}
\title{Print of \code{reproFitTT} object}
\usage{
\method{print}{reproFitTT}(x, ...)
}
\arguments{
\item{x}{An object of class \code{reproFitTT}}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{print} S3 method for the \code{reproFitTT} class.
It prints the underlying JAGS model and some information on the Bayesian 
inference procedure.
}
\examples{
# (1) Load the data
data(cadmium1)

# (2) Create a reproData object
cadmium1 <- reproData(cadmium1)

\dontrun{
# (3) Run the reproFitTT function with the log-logistic
# model
out <- reproFitTT(cadmium1, ecx = c(5, 10, 15, 20, 30, 50, 80),
quiet = TRUE)

# (4) Print the reproFitTT object
out
}

}
\keyword{print}

