% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.survFitVarExp.R
\name{ppc.survFitVarExp}
\alias{ppc.survFitVarExp}
\title{Posterior predictive check plot for \code{survFitVarExp} objects}
\usage{
\method{ppc}{survFitVarExp}(
  x,
  xlab = "Observed nb of survivors",
  ylab = "Predicted nb of survivors",
  main = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{survFitVarExp}}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{Observed nb of survivors}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Predicted nb of survivors}.}

\item{main}{A main title for the plot.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{ppc} S3 method for the \code{survFitVarExp} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFit} objects.
}
\details{
The black points show the observed number of survivors (on \eqn{X}-axis)
 against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise.
}
\examples{

# (1) Load the data
data(propiconazole_pulse_exposure)

# (2) Create an object of class "survData"
dat <- survData(propiconazole_pulse_exposure)

\dontrun{
# (3) Run the survFitTKTD function with the TKTD model ('SD' or 'IT')
out <- survFit(dat, model_type = "SD")

# (4) Plot observed versus predicted values
ppc(out)
}

}
