% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survFitTT.survDataCstExp.R
\name{survFitTT.survDataCstExp}
\alias{survFitTT.survDataCstExp}
\title{Fits a Bayesian concentration-response model for target-time survival analysis}
\usage{
\method{survFitTT}{survDataCstExp}(
  data,
  target.time = NULL,
  lcx = c(5, 10, 20, 50),
  n.chains = 3,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{an object of class \code{survData}}

\item{target.time}{the chosen endpoint to evaluate the effect of the chemical compound
concentration, by default the last time point available for
all concentrations}

\item{lcx}{desired values of \eqn{x} (in percent) for which to compute
\eqn{LC_x}.}

\item{n.chains}{number of MCMC chains, the minimum required number of chains
is 2}

\item{quiet}{if \code{TRUE}, does not print messages and progress bars from
JAGS}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns an object of class \code{survFitTT}, which is a
list with the following information:
\item{estim.LCx}{a table of the estimated \eqn{LC_x} along with their 95\%
credible intervals}
\item{estim.par}{a table of the estimated parameters (medians) and 95\%
credible intervals}
\item{det.part}{the name of the deterministic part of the used model}
\item{mcmc}{an object of class \code{mcmc.list} with the posterior
distribution}
\item{warnings}{a table with warning messages}
\item{model}{a JAGS model object}
\item{parameters}{a list of parameter names used in the model}
\item{n.chains}{an integer value corresponding to the number of chains used
for the MCMC computation}
\item{n.iter}{a list of two indices indicating the beginning and the end of
monitored iterations}
\item{n.thin}{a numerical value corresponding to the thinning interval}
\item{jags.data}{a list of the data passed to the JAGS model}
\item{transformed.data}{the \code{survData} object passed to the function}
\item{dataTT}{the dataset with which the parameters are estimated}
}
\description{
This function estimates the parameters of an concentration-response
model for target-time survival analysis using Bayesian inference. In this model,
the survival rate of individuals at a given time point (called target time) is modeled
as a function of the chemical compound concentration. The actual number of
surviving individuals is then modeled as a stochastic function of the survival
rate. Details of the model are presented in the
vignette accompanying the package.
}
\details{
The function returns
parameter estimates of the concentration-response model and estimates of the so-called
\eqn{LC_x}, that is the concentration of chemical compound required to get an \eqn{(1 - x/100)} survival rate.
}
\keyword{estimation}
