% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot}
\alias{plot}
\alias{plot.mortaar_life_table}
\alias{plot.mortaar_life_table_list}
\title{Plot a mortaar_life_table or a mortaar_life_table_list}
\usage{
\method{plot}{mortaar_life_table}(x, display = c("dx", "qx", "lx", "ex",
  "rel_popx"), prefer.ggplot = TRUE, ...)

\method{plot}{mortaar_life_table_list}(x, display = c("dx", "qx", "lx",
  "ex", "rel_popx"), prefer.ggplot = TRUE, ...)
}
\arguments{
\item{x}{a mortaar_life_table or a mortaar_life_table_list.}

\item{display}{a character vector. Displays the calculated variables as plots. These must include
some of the alternatives \code{dx} for the proportion of deaths, \code{qx} for the probability of
death, \code{lx} for the survivorship, \code{ex} for the life expectancy and \code{rel_popx} for
the population age structure.}

\item{prefer.ggplot}{should ggplot be preferred, if available. Default to TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Plot a mortaar_life_table or a mortaar_life_table_list. There are several different kinds of plots
to explore the different variables. The parameter \code{display} allows to select the variables
of interest.
}
\examples{
# Create a mortaar_life_table from a prepared dataset.
schleswig_1 <- life.table(schleswig_ma[c("a", "Dx")])
plot(schleswig_1)
plot(schleswig_1, display = "qx")

# Create a mortaar_life_table_list from two datasets.
odagsen <- life.table(list(
  "corpus mandibulae" = odagsen_cm[c("a", "Dx")],
  "margo orbitalis" = odagsen_mo[c("a", "Dx")]
))
plot(odagsen)
plot(odagsen, display = "lx")

}
