% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsDoc.R
\docType{data}
\name{Mites}
\alias{Mites}
\title{Mites and Wilt Disease}
\format{A data frame with 47 observations on the following variables.
  \itemize{
    \item{\code{treatment}} {a factor with levels \code{mites} and \code{no mites}}
    \item{\code{outcome}} {a factor with levels \code{wilt} and \code{no wilt}}
    }}
\source{
Statistics for the Life Sciences, Third Edition; Myra Samuels & Jeffrey Witmer (2003), page 409.
}
\usage{
data(Mites)
}
\description{
Data from an experiment to test whether exposure to mites protects against Wilt Disease in
cotton plants.
}
\details{
Researchers suspected that attack of a plant by one organism induced resistance to subsequent attack by a different organism.  Individually potted cotton plants were randomly allocated to two groups: infestation by spider mites or no infestation.  After two weeks the mites were dutifully removed by a conscientious research assistant, and both groups were inoculated with Verticillium, a fungus that causes Wilt disease.  More information can be found at \url{https://www.causeweb.org/webinar/activity/2010-01/}.
}
\examples{
data(Mites)
if (require(mosaic)) {
  tally(~ treatment + outcome, data=Mites)
  tally(~ outcome | treatment, format="percent", data=Mites)
}

}
\keyword{datasets}
