% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{Birthdays}
\alias{Birthdays}
\title{US Births in 1969 - 1988}
\format{A data frame with 374221 observations on the following variables.
  \itemize{
    \item{\code{state}} {state where child was born}
    \item{\code{year}} {year (1969-1988)}
    \item{\code{month}} {month (1-12)}
    \item{\code{day}} {day of month}
    \item{\code{date}} {date as a date object}
    \item{\code{births}} {number of births}
  }}
\usage{
data(Birthdays)
}
\description{
A day by day record of the number of births in each US State.
}
\examples{
data(Birthdays)
if (require(lattice)) {
  xyplot(births ~ date, Birthdays, subset=state=="CA")
  xyplot(births ~ date, Birthdays, subset=state=="CA",
    groups=wday, type='l')
  if (require(mosaic)) {
    xyplot(births ~ date, type='l',
      data = Birthdays \%>\% group_by(date) \%>\% summarise(births=sum(births)))
    }
  }
}

