% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collinearity.R
\name{collinearity}
\alias{collinearity}
\title{Calculate measures of collinearity}
\usage{
collinearity(formula, data, format = c("SeIF", "degrees", "radians", "VIF"))
}
\arguments{
\item{formula}{a formula giving, on the right-hand side, the explanatory
variables to be considered. Iteractions, etc. may also be specified.}

\item{data}{a data frame from which to draw the variables in the formula}

\item{format}{choice of \code{"SeIF"} for inflation of standard errors,
\code{"degrees"} or \code{"radians"} for collinearity described as an angle
or \code{"VIF"} for the variance inflation factor (which is the square of SeIF).}
}
\description{
Calculate measures of collinearity
}
\examples{
collinearity( ~ cyl * disp * hp, data = mtcars)
collinearity( ~ cyl * disp * hp, data = mtcars, format = "degrees")
}
