% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{listToDf}
\alias{listToDf}
\title{List to data.frame}
\usage{
listToDf(list.object, par.set)
}
\arguments{
\item{list.object}{\verb{[list]} list of individuals, each with elements named
by parameter ids.}

\item{par.set}{\verb{[ParamSet]} parameter set.}
}
\value{
\verb{[data.frame]}
}
\description{
Converts a list to a data.frame based on given parameter set.

List elements must have the correct type with respect to
parameter set. Exceptions are discrete parameters, whose values should be
factors, only characters are accepted and factors are returned.

Returned \code{data.frame} has column names equal to parameter ids. In case
of vector parameters column names will be numbered.
}
\examples{
library(mlrCPO)

# Create parameter set
temp <- c("a", "b", "c")
ps.simple <- pSS(
 num: numeric [0, 10],
 int: integer[0, 10] [[trafo = function(x) x / 10]],
 char: discrete [temp], 
 selector.selection: logical^10)
 
# Sample values as list and convert list to data frame
init.list <- sampleValues(ps.simple, 5, discrete.names = TRUE)
result <- listToDf(init.list, ps.simple)
result

}
