% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.disp.lrt.R
\name{chr.disp.lrt}
\alias{chr.disp.lrt}
\title{Character displacement likelihood ratio test}
\usage{
chr.disp.lrt(emp.tree, emp.data, param.out, posteriorSize = 500)
}
\arguments{
\item{emp.tree}{An empirical phylogeny - a object of class \code{phylo} (see \pkg{ape}).}

\item{emp.data}{Continuous trait data matrix}

\item{param.out}{simulated data from the function \code{chr.disp.sim}}

\item{posteriorSize}{The number of samples to use in the likelihood-ratio test}
}
\value{
List containing element of 'estimates' with the estimates of sigma and a, with the Brownian motion (a = 0) summarised in column one and the character displacement (a > 0) in column two. 'likelihood' contains the likelihood of the Brownian motion model and the character displacement model, and the likelihood ratio test estimate. If used, there is an estimate of Blomberg's K for the empirical and simulated data.
}
\description{
Conducts a likelihood ratio test between empirical data (phylogeny and trait data), and simumlations from the function chr.disp.sim using an approximate Bayesian computation (ABC) approach (Clarke et al. 2017)
}
\examples{
## import finch data form Clarke et al. (2017)
data(finches)
## simulate small amount of data 
## (example only - many more datasets are required for accuracy)
param.simulation <- chr.disp.param(finch.tree, n.sim = 100, n.steps=100,
max.sigma = 8, max.a = 8, ntraits=1, 
allopatry=as.matrix(allopatric.data), mc.cores = 1)
chr.disp.lrt(finch.tree, finch.data, param.simulation, 50)
}
\references{
Clarke M, Thomas GH, Freckleton RP. 2017. Trait evolution in adaptive radiations: modelling and measuring interspecific competition on phylogenies. The American Naturalist. 189, 121-137.
}
\seealso{
\code{\link{chr.disp.sim}}, \code{\link{chr.disp.param}}
}
\author{
Magnus Clarke and Mark Puttick
}
