% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movenetw.R
\name{movenetw}
\alias{movenetw}
\title{R function for calculating least-cost path network}
\usage{
movenetw(
  dtm = NULL,
  origin,
  studyplot = NULL,
  barrier = NULL,
  plot.barrier = FALSE,
  irregular.dtm = FALSE,
  funct = "t",
  move = 16,
  field = 0,
  cogn.slp = FALSE,
  sl.crit = 10,
  W = 70,
  L = 0,
  N = 1,
  V = 1.2,
  z = 9,
  lcp.dens = FALSE,
  transp = 0.5,
  export = FALSE
)
}
\arguments{
\item{dtm}{Digital Terrain Model (RasterLayer class); if not provided, elevation data will be acquired online for the area enclosed by the 'studyplot' parameter (see \code{\link{movecost}}).}

\item{origin}{location(s) around which the boundary(ies) is calculated (SpatialPointsDataFrame class).}

\item{studyplot}{polygon (SpatialPolygonDataFrame class) representing the study area for which online elevation data are acquired (see \code{\link{movecost}}); NULL is default.}

\item{barrier}{area where the movement is inhibited (SpatialLineDataFrame or SpatialPolygonDataFrame class) (see \code{\link{movecost}}).}

\item{plot.barrier}{TRUE or FALSE (default) if the user wants or does not want the barrier to be plotted (see \code{\link{movecost}}).}

\item{irregular.dtm}{TRUE or FALSE (default) if the input DTM features irregular margins (see \code{\link{movecost}}).}

\item{funct}{cost function to be used (for details on each of the following, see \code{\link{movecost}}):\cr
\strong{-functions expressing cost as walking time-}\cr
\strong{t} (default) uses the on-path Tobler's hiking function;\cr
\strong{tofp} uses the off-path Tobler's hiking function;\cr
\strong{mp} uses the Marquez-Perez et al.'s modified Tobler's function;\cr
\strong{icmonp} uses the Irmischer-Clarke's hiking function (male, on-path);\cr
\strong{icmoffp} uses the Irmischer-Clarke's hiking function (male, off-path);\cr
\strong{icfonp} uses the Irmischer-Clarke's hiking function (female, on-path);\cr
\strong{icfoffp} uses the Irmischer-Clarke's hiking function (female, off-path);\cr
\strong{ug} uses the Uriarte Gonzalez's walking-time cost function;\cr
\strong{ma} uses the Marin Arroyo's walking-time cost function;\cr
\strong{alb} uses the Alberti's Tobler hiking function modified for pastoral foraging excursions;\cr
\strong{gkrs} uses the Garmy, Kaddouri, Rozenblat, and Schneider's hiking function;\cr
\strong{r} uses the Rees' hiking function;\cr
\strong{ks} uses the Kondo-Seino's hiking function;\cr
\strong{trp} uses the Tripcevich's hiking function;\cr

\strong{-functions for wheeled-vehicles-}\cr
\strong{wcs} uses the wheeled-vehicle critical slope cost function;\cr

\strong{-functions expressing abstract cost-}\cr
\strong{ree} uses the relative energetic expenditure cost function;\cr
\strong{b} uses the Bellavia's cost function;\cr
\strong{e} uses the Eastman's cost function;\cr

\strong{-functions expressing cost as metabolic energy expenditure-}\cr
\strong{p} uses the Pandolf et al.'s metabolic energy expenditure cost function;\cr
\strong{pcf} uses the Pandolf et al.'s cost function with correction factor for downhill movements;\cr
\strong{m} uses the Minetti et al.'s metabolic energy expenditure cost function;\cr
\strong{hrz} uses the Herzog's metabolic energy expenditure cost function;\cr
\strong{vl} uses the Van Leusen's metabolic energy expenditure cost function;\cr
\strong{ls} uses the Llobera-Sluckin's metabolic energy expenditure cost function;\cr
\strong{a} uses the Ardigo et al.'s metabolic energy expenditure cost function;\cr
\strong{h} uses the Hare's metabolic energy expenditure cost function (for all the mentioned cost functions, see \code{\link{movecost}}).\cr}

\item{move}{number of directions in which cells are connected: 4 (rook's case), 8 (queen's case), 16 (knight and one-cell queen moves; default).}

\item{field}{value assigned to the cells coinciding with the barrier (0 by default) (see \code{\link{movecost}}.}

\item{cogn.slp}{TRUE or FALSE (default) if the user wants or does not want the 'cognitive slope' to be used in place of the real slope (see \code{\link{movecost}}).}

\item{sl.crit}{critical slope (in percent), typically in the range 8-16 (10 by default) (used by the wheeled-vehicle cost function; see \code{\link{movecost}}).}

\item{W}{walker's body weight (in Kg; 70 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{L}{carried load weight (in Kg; 0 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{N}{coefficient representing ease of movement (1 by default) (see \code{\link{movecost}}).}

\item{V}{speed in m/s (1.2 by default) (used by the Pandolf et al.'s, Pandolf et al.s with correction factor, Van Leusen's, and Ardigo et al.'s cost function; if set to 0, it is internally worked out on the basis of Tobler on-path hiking function (see \code{\link{movecost}}).}

\item{z}{zoom level for the elevation data downloaded from online sources (from 0 to 15; 9 by default) (see \code{\link{movecost}} and \code{\link[elevatr]{get_elev_raster}}).}

\item{lcp.dens}{TRUE or FALSE (default) if the user wants or does not want the least-cost paths density raster to be produced.}

\item{transp}{set the transparency of the slopeshade raster that is plotted over the DTM (0.5 by default).}

\item{export}{TRUE or FALSE (default) if the user wants or does not want the LCPs network to be exported as a shapefile, and the LCPs network density as a GeoTiff; the DTM is exported only if it was not provided by the user
and downloaded by the function from online sources.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{dtm: }{Digital Terrain Model ('RasterLayer' class); returned only if acquired online}
 \item{LCPs.netw: }{list containing the LCPs ('SpatialLinesDataFrame' class) split by origin}
 \item{LCPs.netw.merged: }{'SpatialLinesDataFrame' corresponding to the merged LCPs}
 \item{LCPs.netw.neigh: }{list containing the LCPs between neighboring locations ('SpatialLinesDataFrame' class) split by origin}
 \item{LCPs.netw.merged: }{'SpatialLinesDataFrame' corresponding to the merged LCPs between neighboring locations}
 \item{LCPs.density.count: }{raster ('RasterLayer' class) representing the counts of LCPs on each raster's cell}
 \item{LCPs.density.perc: }{same as the preceding, but re-expressing the counts as percentages}
 \item{cost.matrix.min: }{matrix of cost between locations, expressing cost in minutes}
 \item{cost.matrix.hr: }{matrix of cost between locations, expressing cost in hours}
 \item{cost.matrix: }{matrix of cost between locations, expressing cost either in energy or abstract cost, depending on the
 used cost function}
}
}
\description{
The function provides the facility to calculate LCPs between multiple origins.
Two types of networks are produced: one where each origin location is connected to all the others locations; one where
only pairs of neighboring locations are connected. In other words, in the latter case, each location is connected to the location that is the
nearest in terms of walking cost, either in terms of time or energy (or abstract cost), according to the selected cost function.
Optionally, a raster representing the density of the first type of network can be produced.\cr
Visit this \href{https://drive.google.com/file/d/1gLDrkZFh1b_glzCEqKdkPrer72JJ9Ffa/view?usp=sharing}{LINK} to access the package's vignette.\cr
}
\details{
Like \code{movecost()}, the function just requires an input DTM ('RasterLayer' class) and an origin dataset  ('SpatialPointsDataFrame' class).
If a DTM is not provided, \code{movenetw()} downloads elevation data from online sources for the area enclosed by the polygon fed via
the \code{studyplot} parameter (see \code{\link{movecost}} for more details). Under the hood, \code{movenetw()} relies on \code{movecost()} and implements the same cost functions:
see the help documentation of \code{movecost()} for further information.\cr

\code{movenetw()} produces a plot representing the input DTM overlaid by a slopeshade raster, whose transparency can be adjusted using
the 'transp' parameter. On the rendered plot, the LPCs network ('SpatialLinesDataFrame' class) is represented by black lines. Optionally,
by setting the parameter \code{lcp.dens()} to \code{TRUE}, the function produces a raster representing the density of the LCPs connecting each location to all the
other locations. The raster, which is rendered overlaid to a slopeshade visualization, expresses the density of LCPs as percentages.
The percentages are calculated in relation to the maximum number of LCPs passing through the same cell stored in the raster.
A density raster expressing counts is NOT rendered BUT is returned by the function. The density raster retains the cell size and coordinate system of the input DTM.\cr

The function returns a list storing the DTM (only in case this has not been fed into the function but acquired online), a list of LCPs
split by origin, a SpatialLineDataFrame representing the merged LCPs, two rasters representing the LCPs network density
expressed as counts and percentages respectively, and cost matrices. As for the latter, if the selected cost function defines cost as
walking time, two matrices are returned, one expressing time in minutes, one in hours (\strong{note} that the values are in decimal format).
If the selected cost function expresses cost differently (i.e., energy or abstract cost), the two above mentioned cost matrices will be set to NULL,
and a third cost matrix will store all the pair-wise costs.\cr

The above mentioned data (DTM, LCPs, network density) can be exported by setting the \code{export} parameter to \code{TRUE} The LCPs network (exported as a shapefile)
and the density raster (as a GeoTiff) will bear a suffix indicating the used cost function.\cr
}
\examples{
# load a sample Digital Terrain Model
data(volc)


# load the sample destination locations on the above DTM
data(destin.loc)


# calculate the least-cost path network using the Tobler's hiking
# function (for on-path walking)

result <- movenetw(dtm=volc, origin=destin.loc[c(1,2,4),], move=8, funct="t")


}
\seealso{
\code{\link{movecost}}
}
\keyword{movenetw}
