% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{plot_phase_difference}
\alias{plot_phase_difference}
\title{Plot a coherency of a wavelet object}
\usage{
plot_phase_difference(obj, view, ...)
}
\arguments{
\item{obj}{analyze.coherency object.}

\item{view}{View object.}

\item{...}{passed to \code{\link[WaveletComp:wc.phasediff.image]{WaveletComp::wc.phasediff.image()}}.}
}
\value{
a list of class \verb{graphical parameters}
}
\description{
Plot a coherency of a wavelet object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
pv1 <- subset(pv, Time >= 10 & Time <= 20)
co <- analyze_coherency(pv1, c("Nose_x", "Nose_y"))
plot_phase_difference(co, pv1)
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{analyze_wavelet}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_sel_phases}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
