% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{specgram_plot}
\alias{specgram_plot}
\title{Specgram Plot}
\usage{
specgram_plot(obj, ...)
}
\arguments{
\item{obj}{\code{View} object.}

\item{...}{passed to \code{\link[signal:specgram]{signal::specgram()}}.}
}
\value{
a \code{ggplot} object.
}
\description{
Specgram Plot
}
\examples{
\donttest{
r <- get_recording("NIR_ABh_Puriya", fps = 25)
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
sub_pv <- subset(pv, Time >= 15 & Time <= 25, columns = c("RWrist_x", "RWrist_y"))
specgram_plot(sub_pv)
fv <- apply_filter_sgolay(pv, data_points = c("RWrist"), n = 11, p = 4)
sub_fv <- subset(fv, Time >= 15 & Time <= 25, columns = c("RWrist_x", "RWrist_y"))
specgram_plot(sub_fv)
specgram_plot(sub_fv, window = 200) + ggplot2::scale_fill_gradient(low = "white", high = "black")
}
}
