% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion.R
\name{velocity_dp}
\alias{velocity_dp}
\title{Velocity plot of a view object}
\usage{
velocity_dp(obj, add_mean = TRUE, vscale = 5, maxpts = 10000, alpha = 0.5, ...)
}
\arguments{
\item{obj}{View object.}

\item{add_mean}{add the mean to each line? (default is TRUE).}

\item{vscale}{a vertical scaling to apply to the plot (default is 5).}

\item{maxpts}{maximum number of points to plot.}

\item{alpha}{ggplot aesthetic value.}

\item{...}{passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}},}
}
\value{
a \code{ggplot} object.
}
\description{
Velocity plot of a view object
}
\examples{
r1 <- get_sample_recording()
rv1 <- get_raw_view(r1, "Central", "", "Sitar")
pv1 <- get_processed_view(rv1)
dp <- c("LWrist", "RWrist", "LElbow", "RElbow", "LEye", "REye", "Neck", "MidHip")
fv1 <- apply_filter_sgolay(pv1, data_point = dp, n = 41, p = 4)
sub_fv1 <- subset(fv1, Time >= 10 & Time <= 20, by = 2)
velocity_dp(sub_fv1)
}
