% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset,imputed-method}
\alias{subset,imputed-method}
\alias{subset,probabilities-method}
\alias{subset,mpcross-method}
\alias{subset,mpcrossMapped-method}
\alias{subset,mpcrossRF-method}
\alias{subset,mpcrossLG-method}
\alias{subset,lg-method}
\alias{subset,geneticData-method}
\alias{subset,hetData-method}
\alias{subset,rf-method}
\alias{subset,rawSymmetricMatrix-method}
\title{Subset data}
\usage{
\S4method{subset}{imputed}(x, ...)

\S4method{subset}{probabilities}(x, ...)

\S4method{subset}{mpcross}(x, ...)

\S4method{subset}{mpcrossMapped}(x, ...)

\S4method{subset}{mpcrossRF}(x, ...)

\S4method{subset}{mpcrossLG}(x, ...)

\S4method{subset}{lg}(x, ...)

\S4method{subset}{geneticData}(x, ...)

\S4method{subset}{hetData}(x, ...)

\S4method{subset}{rf}(x, ...)

\S4method{subset}{rawSymmetricMatrix}(x, ...)
}
\arguments{
\item{x}{The object to be subset}

\item{...}{A method to use to subset (markers, lines, positions or chromosomes), and values for that method.}
}
\value{
A subsetted object, of the same type as the input.
}
\description{
Subset data objects by line names, chromosomes, linkage groups, markers or positions
}
\details{
mpMap2 objects can be subset in a number of different ways, depending on the particular class of the object that is contained. 

Subsetting by \code{"lines"} subsets by the genetic lines in the final population. Line names or line indices can be used, although line names should be preferred. Any information about recombination fractions will be discarded. Subsetting by \code{"chromosomes"} keeps only certain chromosomes, and requires that the object have a genetic map. Subsetting by \code{"markers"} keeps only certain genetic markers. Data about imputed IBD genotypes and IBD genotype probabilities is discarded. Subsetting by \code{"positions"} only subsets the imputed IBD genotypes and IBD probability data, and does not subset the underlying markers. Subestting by \code{"groups"} retains only certain linkage groups. 

An object of class \code{mpcross} can be subset by genetic lines or markers. 

Objects of classes \code{mpcrossLG} or \code{mpcrossRF} can be subset by genetic lines, markers or linkage groups. 

An object of class \code{mpcrossMapped} can be subset by genetic lines, markers or chromosomes. 

The remainder of the subsetting methods are not expected to be called directly by the user. They subset internal components, and are used internally by the top-level methods.
}
