% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChromosomes.R
\name{getChromosomes}
\alias{getChromosomes}
\title{Get chromosome assignment per marker}
\usage{
getChromosomes(mpcrossMapped, markers)
}
\arguments{
\item{mpcrossMapped}{The object containing the map of interest}

\item{markers}{The markers for which we want the chromosomes}
}
\value{
A character vector, with names corresponding to markers, and values corresponding to the chromosome on which the named marker is located.
}
\description{
Get chromosome assignment per marker from an \code{mpcross} object.
}
\details{
Extract a character vector, with names corresponding to markers, and values corresponding to the chromosome on which the named marker is located.
}
\examples{
map <- qtl::sim.map()
pedigree <- f2Pedigree(1000)
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane, seed = 1)
mappedCross <- mpcrossMapped(cross = cross, map = map)
chromosomeAssignment <- getChromosomes(mappedCross, markers(mappedCross))
chromosomeAssignment
}
