% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_response_rate.R
\name{plot_response_rate}
\alias{plot_response_rate}
\title{Plots response rate per day (and per participant)}
\usage{
plot_response_rate(data, valid_col, participant_col, time_col)
}
\arguments{
\item{data}{data frame with data}

\item{valid_col}{name of the column that stores whether the beep
was answered or not}

\item{participant_col}{name of the column that stores the participant id
(or equivalent)}

\item{time_col}{name of the column that stores the time of the beep}
}
\value{
a ggplot object with the response rate per day (x axis)
and participant (color)
}
\description{
This function returns a ggplot object with the response rate per day (x axis) and
participant (color). Note that instead of using calendar dates, the function returns a plot
grouped by the day inside the study for the participant.
}
\examples{
# load data
data(example_data)

# make plot with plot_response_rate
plot_response_rate(data = example_data,
time_col = sent,
participant_col = participant,
valid_col = answered)
# The resulting ggplot object can be formatted using ggplot2 functions (see ggplot2
# documentation).

}
