% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{get_activity}
\alias{get_activity}
\title{Get a summary of physical activity (recognition)}
\usage{
get_activity(
  db,
  participant_id = NULL,
  confidence = 70,
  direction = "forward",
  start_date = NULL,
  end_date = NULL,
  by = c("Total", "Day", "Hour")
)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}

\item{confidence}{The minimum confidence (0-100) that should be assigned to an observation by
Activity Recognition.}

\item{direction}{The directionality of the duration calculation, i.e. \eqn{t_{t-1} - t} or
\eqn{t - t_{t+1}}.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}

\item{by}{Either 'Total', 'Hour', or 'Day' indicating how to summarise the results.}
}
\value{
A tibble containing a column 'activity' and a column 'duration' for the hourly
activity duration.
}
\description{
Get a summary of physical activity (recognition)
}
