% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{summary.cmp}
\alias{summary.cmp}
\alias{print.summary.cmp}
\title{Summarizing COM-Poisson Model Fit}
\usage{
\method{summary}{cmp}(object, ...)

\method{print}{summary.cmp}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{glm.cmp}.}

\item{...}{other arguments passed to or from other methods  (currently unused).}

\item{x}{a result of the \emph{default} method of \code{summary()}.}

\item{digits}{numeric; minimum number of significant digits to be used for most numbers.}

\item{signif.stars}{logical. If TRUE, ‘significance stars’ are printed for each coefficient.}
}
\value{
\code{summary.cmp} returns an object of class "summary.cmp", a list containing at least the following components:
\item{call}{the component from object.}
\item{family}{the component from object.}
\item{deviance; residual_deviance}{the component from object.}
\item{df_residual}{the component from object.}
\item{df_null}{the component from object.}
\item{null_deviance}{the component from object.}
\item{deviance_resid}{the deviance residuals: see residuals.cmp.}
\item{coefficients}{the matrix of coefficients, standard errors, z-values and p-values.}
\item{df}{a 3-vector of the rank of the model and the number of residual degrees of freedom, plus number of coefficients.}
}
\description{
\code{summary} method for class \code{cmp}.
}
\details{
\code{print.summary.glm} tries to be smart about formatting the coefficients, standard errors
and gives 'significance stars'. The \code{coefficients} component of the result gives the
estimated coefficients and their estimated standard errors, together with their ratio. This
third column is labelled as \code{Z value} as the dispersion is fixed for this family. A
forth column gives the two-tailed p-value corresponding to \code{Z value} based on
the asymptotic Normal reference distribution.
}
\examples{
## For examples see example(glm.cmp)
}
\seealso{
\code{\link{coef.cmp}}, \code{\link{fitted.cmp}}, \code{\link{glm.cmp}}.
}
