\name{print.mpoly}
\alias{print.mpoly}
\title{Pretty printing of multivariate polynomials.}
\usage{
  \method{print}{mpoly}(x, stars = FALSE, varorder, order,
    ...)
}
\arguments{
  \item{x}{an object of class mpoly}

  \item{stars}{print the multivariate polynomial in the
  more computer-friendly asterisk notation (default FALSE)}

  \item{varorder}{the order of the variables}

  \item{order}{a total order used to order the monomials in
  the printing}

  \item{...}{additional parameters}
}
\value{
  Invisible string of the printed object.
}
\description{
  This is the major function used to view multivariate
  polynomials.
}
\examples{
( list <- list(c(x = 5, coef = 2), c(y = 2, coef = -3), c(x = 1, y = 3, coef = 1)) )
p <- mpoly(list)
p
s <- print(p)
s

print(p, order = 'lex') # -> 2 x^5  +  x y^3  -  3 y^2
print(p, order = 'lex', varorder = c('y','x')) # -> y^3 x  -  3 y^2  +  2 x^5
print(p, varorder = c('y','x')) # -> 2 x^5  -  3 y^2  +  y^3 x



print(p, stars = TRUE)
}

