% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.QeffRes.R
\name{summary.QeffRes}
\alias{summary.QeffRes}
\title{Summary of \code{QeffRes} object}
\usage{
\method{summary}{QeffRes}(object, QTL = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{QeffRes} obtained with
function \code{\link{QTL_gen_effects}}.}

\item{QTL}{\code{Numeric} vector indicating the QTL positions for which the
QTL effect must be printed. Default = NULL.}

\item{...}{Ignored.}
}
\description{
\code{summary} for object of class \code{QeffRes}.
}
\examples{

data(mppData)
SIM <- mpp_SIM(mppData)
QTL <- QTL_select(SIM)
QTL.effects <- QTL_gen_effects(mppData = mppData, QTL = QTL, Q.eff = "cr")
summary(QTL.effects)

}
\seealso{
\code{\link{QTL_gen_effects}}
}
