% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBD.mppData.R
\name{IBD.mppData}
\alias{IBD.mppData}
\title{IBD coding for \code{mppData} objects}
\usage{
IBD.mppData(mppData, het.miss.par = TRUE, subcross.ind = NULL,
  par.per.subcross = NULL, type, F.gen = NULL, BC.gen = NULL,
  type.mating = NULL, error.prob = 1e-04, map.function = "haldane")
}
\arguments{
\item{mppData}{An object of class \code{mppData}. the \code{mppData} must
have been processed using: \code{\link{create.mppData}},
\code{\link{QC.mppData}}, and \code{\link{IBS.mppData}}.}

\item{het.miss.par}{\code{Logical} value. if \code{het.miss.par = TRUE},
the function will use the offspring segregation to try to infer the allele
that was transmitted by the heterozygous or missing parent at a particular
locus to make the ABH conversion. Default = TRUE.}

\item{subcross.ind}{Optional \code{character} vector specifying to which
sub-cross each genotype belong. Default = NULL.}

\item{par.per.subcross}{Optional three columns \code{Character matrix}
specifying : 1) the sub-cross indicators; 2) the parents 1 identifiers
of the sub-crosses; 3) the parents 2 identifiers of the sub-crosses.
Default = NULL.}

\item{type}{\code{Character} indicator for the type of population analyzed:
type = "F" for Fn (F cross n generations); type = "BC" for BCn (backcross
n generations); type = "BCsFt" for backcross followed by selfing;
type = "DH" for double haploids; and type = "RIL"
for recombinant inbred lines. For RIL type specify if the population was
obtain using selfing or sibling mating using \code{type.mating}.
If type = "RIL" or "DH", the function does not assume heterozygous marker
scores for these populations and convert them into missing (NA).}

\item{F.gen}{\code{Numeric} integer representing the number of F generations.
For example F.gen = 2 for F2. Default = NULL.}

\item{BC.gen}{\code{Numeric} integer representing the number of
backcross generations. For example BC.gen = 1 for single backcross.
Default = NULL.}

\item{type.mating}{\code{Character} specifying for a RIL population if it was
obtained by selfing ("selfing") or by sibling mating ("sib.mat").
Default = NULL.}

\item{error.prob}{\code{Numeric} value for assumed genotyping error rate
used in the calculation of the penetrance Pr(observed genotype | true genotype).
Default = 0.0001.}

\item{map.function}{\code{Character} expression specifying the type of map
function used to infer the IBD probabilities. possibility to choose
between "haldane", "kosambi","c-f","morgan". Default = "haldane".}
}
\value{
an increased \code{mppData} object containing the the same elements
as the \code{mppData} object provided as argument and the
following new elements:

\item{geno.IBD}{A R/qtl \code{cross.object} containing the IBD probabilities.}

\item{n.zigo}{\code{Numeric} value Indicating the number of different
genotypes: 2 (AA/BB) or 3 (AA/AB/BB)}

\item{type}{\code{Character} expression indicating the type of population.}
}
\description{
The function first converts genotype data into ABH format. Then it calculates
within cross identical by descent (IBD) probabilities.
}
\details{
The function first transforms genotype data into within cross ABH format.
The function takes the parents of the different cross as
reference and assigns the following scores: "A" if the offspring score is
equivalent to parent 1; "B" if it is equivalent to parent 2; "H" if it is
heterozygous. The function attributes NA for missing when: 1) the offspring
score is missing; 2) the two parents have the same score; or
3) when at least one parental score is missing.

If a parent score is heterozygous or missing (\code{het.miss.par = TRUE}),
the assignment rules are the following. If the two parents are
heterozygous or one parent is heterozygous and the other missing, the
offspring get NA since the parental origin can not be inferred with certainty.
If one parent is heterozygous or missing and the second parent is
homozygous, the function looks at offspring segregating pattern to
infer which allele was transmitted by the heterozygous parent. If this is
possible we consider the heteroxzygous parent as homozygous for the
transmitted allele and use this allele score for ABH assignment.

The ABH assignment can be performed using sub-cross structure providing
information about sub-cross in arguments \code{subcross.ind} and
\code{par.per.subcross}.

Then the function calculates the IBD probabilities using \code{read.cross()}
and \code{calc.genoprob()} functions from the R/qtl package
(Broman et al. 2009).

The type of population must be specified in argument \cite{type}. Different
population types are possible: F-type ('F'), back-cross ('BC'), backcross
followed by selfing ('BCsFt'), double haploid ('DH'), and recombinant imbred
lines ('RIL'). The number of F and BC generations can be specified using
\code{F.gen} and \code{BC.gen}. The argument \code{type.mating} specifies if
F and RIL populations were obtained by selfing or by sibling mating.

DH and RIL populations are read as back-cross by R/qtl. For these two
population types, heterozygous scores will be treated as missing values.
}
\examples{

data(mppData_init)

mppData <- QC.mppData(mppData_init)
mppData <- IBS.mppData(mppData = mppData)

mppData <- IBD.mppData(mppData = mppData, het.miss.par = TRUE, type = 'RIL',
                       type.mating = 'selfing')


}
\references{
Broman KW, Wu H, Sen S, Churchill GA (2003) R/qtl: QTL mapping
in experimental crosses. Bioinformatics 19:889-890.

Broman, K. W., & Sen, S. (2009). A Guide to QTL Mapping with R/qtl (Vol. 46).
New York: Springer.
}
\seealso{
\code{\link{create.mppData}}, \code{\link{QC.mppData}},
\code{\link{IBS.mppData}}
}
\author{
Vincent Garin
}
