% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc_mat_QTL.R
\name{inc_mat_QTL}
\alias{inc_mat_QTL}
\title{QTL incidence matrix}
\usage{
inc_mat_QTL(x, mppData, Q.eff, order.MAF = FALSE)
}
\arguments{
\item{x}{\code{Integer} value indicating the genetic position on the map
(\code{mppData$map}) of the QTL incidence matrix.}

\item{mppData}{An object of class \code{mppData}.}

\item{Q.eff}{\code{Character} expression indicating the assumption concerning
the QTL effects: 1) "cr" for cross-specific; 2) "par" for parental; 3) "anc"
for ancestral; 4) "biall" for a bi-allelic. For more details see
\code{\link{mpp_SIM}}. Default = "cr".}

\item{order.MAF}{\code{Logical} value specifying if the QTL incidence matrix
should be ordered by allele frequency for a parental and ancestral QTL
incidence matrix. The column will be ordered from the least to the most frequent
allele. Default = FALSE.}
}
\value{
Return:

\item{QTL.mat}{QTL incidence matrix. For the
cross-specific model, it represents the difference between the
number of allele from parent 2 or B and parent 1 or A divided by two. For
parental (ancestral) model it represents the expected number of parental
(ancestral) allele copies. For the bi-allelic model, it represents the number
of copies of the least frequent allele.}
}
\description{
Build a single position QTL incidences matrix.
}
\examples{

data(mppData)

QTLmatCr <- inc_mat_QTL(x = 2, mppData = mppData, Q.eff = "cr")

QTLmatPar <- inc_mat_QTL(x = 2, mppData = mppData, Q.eff = "par")

QTLmatAnc <- inc_mat_QTL(x = 2, mppData = mppData, Q.eff = "anc")

QTLmatBi <- inc_mat_QTL(x = 2, mppData = mppData, Q.eff = "biall")


}
\seealso{
\code{\link{mpp_SIM}},
}
\author{
Vincent Garin
}
