% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suf_stat.R
\name{smr_stat}
\alias{smr_stat}
\title{Summary Statistics}
\usage{
smr_stat(Z, mrfi, family)
}
\arguments{
\item{Z}{A \code{matrix} object containing the observed MRF. \code{NA} values can be
used to create a subregion of the lattice for non-rectangular data.}

\item{mrfi}{A \code{\link[=mrfi-class]{mrfi}} object representing the
interaction structure.}

\item{family}{The family of parameter restrictions to potentials. Families
are:
\code{'onepar'}, \code{'oneeach'}, \code{'absdif'}, \code{'dif'} or \code{'free'}.
See \code{\link[=mrf2d-family]{mrf2d-familiy}}.}
}
\value{
A numeric vector with the summarized counts.
}
\description{
Computes the summary count statistics of a field given an
interaction structure and a restriction family.
}
\details{
The order the summarized counts appear in the summary vector matches
the order in \code{\link[=smr_array]{smr_array()}}.
}
\examples{
smr_stat(Z_potts, mrfi(1), "onepar")
smr_stat(Z_potts, mrfi(1), "oneeach")

}
\author{
Victor Freguglia
}
