% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modlib.R
\name{modlib}
\alias{modlib}
\title{Internal model library.}
\usage{
modlib(list = FALSE)
}
\arguments{
\item{list}{list available models}
}
\description{
Internal model library.
}
\details{
See \code{\link{modlib_details}}, \code{\link{modlib_pk}}, 
\code{\link{modlib_pkpd}}, 
\code{\link{modlib_tmdd}}, \code{\link{modlib_viral}} for details.

Call \code{modlib(list=TRUE)} to list available models.  Once the model 
is loaded (see examples below), call \code{as.list(mod)$code} to see
model code and equations.
}
\examples{
\dontrun{
mod <- mread("pk1cmt", modlib())
mod <- mread("pk2cmt", modlib()) 
mod <- mread("pk3cmt", modlib()) 
mod <- mread("pk1",    modlib())
mod <- mread("pk2",    modlib())
mod <- mread("popex",  modlib())
mod <- mread("irm1",   modlib()) 
mod <- mread("irm2",   modlib()) 
mod <- mread("irm3",   modlib()) 
mod <- mread("irm4",   modlib())
mod <- mread("emax",   modlib())
mod <- mread("effect", modlib())
mod <- mread("tmdd",   modlib())
mod <- mread("viral1", modlib())
mod <- mread("viral2", modlib())

mrgsolve:::code(mod)
}

}
