% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\docType{methods}
\name{param}
\alias{param}
\alias{param,mrgmod-method}
\alias{param,mrgsims-method}
\alias{param,missing-method}
\alias{param,list-method}
\alias{param,ANY-method}
\alias{show,parameter_list-method}
\alias{allparam}
\alias{as.param}
\alias{as.param,list-method}
\alias{as.param,numeric-method}
\alias{as.param,parameter_list-method}
\alias{as.param,missing-method}
\alias{$,mrgmod-method}
\title{Create and work with parameter objects}
\usage{
param(.x, ...)

\S4method{param}{mrgmod}(.x, .y = list(), ..., .pat = "*",
  .strict = FALSE)

\S4method{param}{mrgsims}(.x, ...)

\S4method{param}{missing}(..., .strict = TRUE)

\S4method{param}{list}(.x, ...)

\S4method{param}{ANY}(.x, ...)

\S4method{show}{parameter_list}(object)

allparam(.x)

as.param(.x, ...)

\S4method{as.param}{list}(.x, ...)

\S4method{as.param}{numeric}(.x, ...)

\S4method{as.param}{parameter_list}(.x, ...)

\S4method{as.param}{missing}(.x, ...)

\S4method{$}{mrgmod}(x, name)
}
\arguments{
\item{.x}{the model object}

\item{...}{passed along or name/value pairs to update the parameters 
in a model object}

\item{.y}{list to be merged into parameter list}

\item{.pat}{a regular expression (character) to be applied as a filter 
for which parameters to show when printing}

\item{.strict}{if \code{TRUE}, all names to be updated must be found 
in the parameter list}

\item{object}{passed to show}

\item{x}{mrgmod object}

\item{name}{parameter to take}
}
\value{
An object of class \code{parameter_list} (see 
\code{\link{numericlist}}).
}
\description{
See \code{\link{numericlist}} for methods to deal with 
\code{parameter_list} objects.
}
\details{
Can be used to either get a parameter list object from a 
\code{mrgmod} model object or to update
the parameters in a model object.  For both uses, the return value 
is a \code{parameter_list} object.
For the former use, \code{param} is usually called to print
the parameters to the screen, but the parameter_list object can also 
be coreced to a list or numeric R object.
}
\examples{
## example("param")
mod <- mrgsolve:::house()

param(mod)
param(mod, .pat="^(C|F)") ## may be useful when large number of parameters

class(param(mod))

param(mod)$KA

as.list(param(mod))
as.data.frame(param(mod))

}
\keyword{param}
