% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle_spec_block.R
\name{BLOCK_PARSE}
\alias{BLOCK_PARSE}
\alias{PARAM}
\alias{FIXED}
\alias{THETA}
\alias{INIT}
\alias{CMT}
\alias{CAPTURE}
\alias{HANDLEMATRIX}
\title{Functions to parse code blocks}
\usage{
PARAM(
  x,
  env,
  pos = 1,
  annotated = FALSE,
  object = NULL,
  as_object = FALSE,
  covariates = FALSE,
  ...
)

FIXED(x, env, pos = 1, annotated = FALSE, ...)

THETA(
  x,
  env,
  pos = 1,
  annotated = FALSE,
  object = NULL,
  as_object = FALSE,
  name = "THETA",
  fill = NULL,
  ...
)

INIT(x, env, pos = 1, annotated = FALSE, object = NULL, as_object = FALSE, ...)

CMT(
  x,
  env,
  pos = 1,
  annotated = FALSE,
  object = NULL,
  as_object = FALSE,
  number = NULL,
  prefix = "A",
  ...
)

CAPTURE(x, env, pos = 1, annotated = FALSE, etas = NULL, ...)

HANDLEMATRIX(
  x,
  env,
  pos = 1,
  annotated = FALSE,
  object = NULL,
  as_object = FALSE,
  name = "...",
  type = NULL,
  oclass = "",
  prefix = "",
  labels = NULL,
  unlinked = FALSE,
  ...
)
}
\arguments{
\item{x}{data}

\item{env}{parse environment}

\item{pos}{block position}

\item{annotated}{logical}

\item{object}{the name of an object in \code{ENV}}

\item{as_object}{indicates that object code is being provided}

\item{covariates}{logical}

\item{...}{passed}

\item{name}{block name}

\item{fill}{deprecated; not used}

\item{number}{number of compartments to create}

\item{prefix}{a prefix to add to the label}

\item{etas}{allows for block capture of ETAs in the simulated output;
this should be R code that will get parsed and evaluated; the result should 
be an integer-like vector which identifies which ETAs will be captured.}

\item{type}{internal use}

\item{oclass}{internal use}

\item{labels}{aliases to use for simulated ETA values}

\item{unlinked}{internal use}
}
\description{
Most of the basic blocks are listed in this help topic.
But see also \code{\link[=PKMODEL]{PKMODEL()}} which has more-involved
options and is documented separately.
}
\details{
When using \code{object} or \code{as_object} populate the block contents, the following
types are required
\itemize{
\item \code{PARAM}: a named list
\item \code{INIT} : a named list
\item \code{THETA} : a numeric vector; names are ignored
\item \code{CMT}: a character vector
\item \code{OMEGA}: matrix; set rownames on the matrix to create ETA labels; setting
rownames is the only way to specify \code{labels} when working through the
\code{object} or \code{as_object} directives
\item \code{SIGMA}: matrix; set rownames on the matrix to create EPS labels; setting
rownames is the only way to specify \code{labels} when working through the
\code{object} or \code{as_object} directives
}
}
\seealso{
\code{\link[=PKMODEL]{PKMODEL()}}
}
