% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renumber_time_id.R
\name{renumber_time_id}
\alias{renumber_time_id}
\title{Renumber the time ID per case (i.e. Tumor sequence)}
\usage{
renumber_time_id(
  df,
  new_time_id_var,
  dattype = "zfkd",
  case_id_var = NULL,
  time_id_var = NULL,
  diagdat_var = NULL,
  timevar_max = Inf
)
}
\arguments{
\item{df}{dataframe}

\item{new_time_id_var}{Name of the newly calculated variable for time_id. Required.}

\item{dattype}{Type of cancer registry data. Can be "seer" or "zfkd". Default is "zfkd".}

\item{case_id_var}{String with name of ID variable indicating same patient.
E.g. \code{case_id_var="PUBCSNUM"} for SEER data.}

\item{time_id_var}{String with name of variable that indicates diagnosis per patient.
E.g. \code{time_id_var="SEQ_NUM"} for SEER data.}

\item{diagdat_var}{String with name of variable that indicates date of diagnosis per event.
E.g. \code{diagdat_var="t_datediag"} for SEER data.}

\item{timevar_max}{Numeric; default Inf. Maximum number of cases per id.
All tumors > timevar_max will be deleted.}
}
\value{
df
}
\description{
Renumber the time ID per case (i.e. Tumor sequence)
}
\examples{

data(us_second_cancer)
us_second_cancer \%>\%
 #only select first 10000 rows so example runs faster
 dplyr::slice(1:10000) \%>\%
 msSPChelpR::renumber_time_id(new_time_id_var = "t_tumid",
                             dattype = "seer",
                             case_id_var = "fake_id")
                             
}
