% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_data_color.R
\name{chart_labels_text}
\alias{chart_labels_text}
\title{Modify labels font settings}
\usage{
chart_labels_text(x, values)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{values}{a named list of \code{fp_text} objects to map data labels to.
It is a named list, the values will be matched based on the names.
If it contains only one \code{fp_text} object, it will be associated to all existing series.}
}
\description{
Specify mappings from levels in the data to displayed text font settings.
}
\examples{
library(officer)

fp_text_settings <- list(
  serie1 = fp_text(font.size = 7, color = "red"),
  serie2 = fp_text(font.size = 0, color = "purple"),
  serie3 = fp_text(font.size = 19, color = "wheat")
)

barchart <- ms_barchart(
  data = browser_data,
  x = "browser", y = "value", group = "serie")
barchart <- chart_data_labels(barchart, show_val = TRUE)
barchart <- chart_labels_text( barchart,
  values = fp_text_settings )
}
