% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_chart.R
\name{ms_scatterchart}
\alias{ms_scatterchart}
\title{scatterchart object}
\usage{
ms_scatterchart(data, x, y, group = NULL, labels = NULL)
}
\arguments{
\item{data}{a data.frame}

\item{x}{x colname}

\item{y}{y colname}

\item{group}{grouping colname used to split data into series. Optional.}

\item{labels}{colnames of columns to be used as labels into series. Optional.
If more than a name, only the first one will be used as label, but all
labels (transposed if a group is used) will be available in the Excel file
associated with the chart.}
}
\description{
Creation of a scatterchart object that can be
inserted in a 'Microsoft' document.
}
\section{Illustrations}{


\if{html}{

\figure{fig_ms_scatterchart_1.png}{options: width=60\%}

\figure{fig_ms_scatterchart_2.png}{options: width=60\%}

}
}

\examples{
library(officer)
# example chart_01 -------
chart_01 <- ms_scatterchart(data = mtcars, x = "disp",
                         y = "drat")
chart_01 <- chart_settings(chart_01, scatterstyle = "marker")


# example chart_02 -------
chart_02 <- ms_scatterchart(data = iris, x = "Sepal.Length", y = "Petal.Length", group = "Species")
chart_02 <- chart_settings(chart_02, scatterstyle = "marker")

}
\seealso{
\code{\link[=chart_settings]{chart_settings()}}, \code{\link[=chart_ax_x]{chart_ax_x()}}, \code{\link[=chart_ax_y]{chart_ax_y()}},
\code{\link[=chart_data_labels]{chart_data_labels()}}, \code{\link[=chart_theme]{chart_theme()}}, \code{\link[=chart_labels]{chart_labels()}}

Other 'Office' chart objects: 
\code{\link{ms_areachart}()},
\code{\link{ms_barchart}()},
\code{\link{ms_linechart}()}
}
\concept{'Office' chart objects}
