% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body_add_chart.R
\name{body_add_chart}
\alias{body_add_chart}
\title{add chart into a Word document}
\usage{
body_add_chart(x, chart, style = NULL, pos = "after", width = 5, height = 3)
}
\arguments{
\item{x}{an rdocx object}

\item{chart}{an \code{ms_chart} object.}

\item{style}{paragraph style}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}

\item{height, width}{height and width in inches.}
}
\description{
add a \code{ms_chart} into an rdocx object, the graphic will be
inserted in an empty paragraph.
}
\examples{
library(officer)
my_barchart <- ms_barchart(data = browser_data,
  x = "browser", y = "value", group = "serie")
my_barchart <- chart_settings( my_barchart, grouping = "stacked",
  gap_width = 50, overlap = 100 )

doc <- read_docx()
doc <- body_add_chart(doc, chart = my_barchart, style = "centered")
print(doc, target = tempfile(fileext = ".docx"))
}
