test_that("msigdbr_collections()", {
  skip_if_not_installed("msigdbdf")
  collections <- msigdbr_collections()
  expect_s3_class(collections, "tbl_df")
  expect_gt(nrow(collections), 10)
  expect_lt(nrow(collections), 30)
  expect_match(collections$gs_collection, "H", fixed = TRUE, all = FALSE)
  expect_match(collections$gs_collection, "C2", fixed = TRUE, all = FALSE)
  expect_match(collections$gs_collection, "C7", fixed = TRUE, all = FALSE)
  expect_match(collections$gs_collection, "C8", fixed = TRUE, all = FALSE)
})

test_that("msigdbr_collections() db_species", {
  skip_if_not_installed("msigdbdf")
  chs <- msigdbr_collections(db_species = "Hs")
  expect_s3_class(chs, "tbl_df")
  expect_gt(nrow(chs), 10)
  expect_lt(nrow(chs), 30)
  expect_match(chs$gs_collection, "H", fixed = TRUE, all = FALSE)
  expect_match(chs$gs_collection, "C8", fixed = TRUE, all = FALSE)
  cmm <- msigdbr_collections(db_species = "Mm")
  expect_s3_class(cmm, "tbl_df")
  expect_gt(nrow(cmm), 10)
  expect_lt(nrow(cmm), 30)
  expect_match(cmm$gs_collection, "MH", fixed = TRUE, all = FALSE)
  expect_match(cmm$gs_collection, "M8", fixed = TRUE, all = FALSE)
})
