% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-model.R
\docType{class}
\name{Model}
\alias{Model}
\title{Create the definition of multi-table and single-table datasets}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Model
}
\description{
Create the definition of a dataset containing one or more tables. The definition includes the name and description of the dataset and the name and description of each table, attribute, and metric within the dataset.
}
\section{Fields}{

\describe{
\item{\code{tables}}{List containing lists of data.frames and corresponding table names}

\item{\code{name}}{Name of the dataset}

\item{\code{description}}{Description of the data set. Must be less than or equal to 250 characters}

\item{\code{folder_id}}{ID of the shared folder that the dataset should be created within. If NULL, defaults to the user's My Reports folder}
}}

\examples{
\donttest{
# Create data frames
df1 <- data.frame("id" = c(1, 2, 3, 4, 5),
                  "first_name" = c("Jason", "Molly", "Tina", "Jake", "Amy"),
                  "last_name" = c("Miller", "Jacobson", "Turner", "Milner", "Cooze"))

df2 <- data.frame("id" = c(1, 2, 3, 4, 5),
                  "age" = c(42, 52, 36, 24, 73),
                  "state" = c("VA", "NC", "WY", "CA", "CA"),
                  "salary" = c(50000, 100000, 75000, 85000, 250000))

# Create a list of tables containing one or more tables and their names
tables = list(list("table_name" = "employee_id",
                    "data_frame" = df1),
              list("table_name" = "employee_data",
                   "data_frame" = df2))

# Generate the data model
model <- Model$new(tables=tables, name="Employees", description="Employee Analytics Data")
model_info <- model$get_model()
}
}
\keyword{datasets}
