% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{grep_subset}
\alias{grep_subset}
\title{Subset a data frame using regex matching on the column name and also on the value}
\usage{
grep_subset(dataFrame, colGrep, subGrep, echo = T, invert = F)
}
\arguments{
\item{dataFrame}{is a data.frame}

\item{colGrep}{is a regex pattern for finding the columns}

\item{subGrep}{is a regex pattern to subset the values in the matched column}

\item{echo}{If TRUE, messages are printed on the console}

\item{invert}{If TRUE, returns everything other than the rows and columns matched using colGrep and subGrep}
}
\description{
Subset a data frame using regex matching on the column name and also on the value
}
\examples{
 
df = data.frame(type = c("sample","event","condition","sample"),value = c("value1","value2",
                 "value3","value4"))
filtered_df = grep_subset(df,"type","sample")                
}
