% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HVT.R
\name{HVT}
\alias{HVT}
\title{Constructing Hierarchical Voronoi Tessellations}
\usage{
HVT(
  dataset,
  nclust = 15,
  depth = 3,
  quant.err = 0.2,
  projection.scale = 10,
  normalize = TRUE,
  distance_metric = c("L1_Norm", "L2_Norm"),
  error_metric = c("mean", "max")
)
}
\arguments{
\item{dataset}{Data frame. A data frame with different columns is given as
input.}

\item{nclust}{Numeric. An integer indicating the number of clusters per
hierarchy (level)}

\item{depth}{Numeric. An integer indicating the number of levels. (1 = No
hierarchy, 2 = 2 levels, etc ...)}

\item{quant.err}{Numeric. A number indicating the quantization error
treshold.}

\item{projection.scale}{Numeric. A number indicating the scale factor for
the tesselations so as to visualize the sub-tesselations well enough.}

\item{normalize}{Logical. A logical value indicating if the columns in your
dataset should be normalized. Default value is TRUE.}

\item{distance_metric}{character. The distance metric can be 'Euclidean" or "Manhattan". Euclidean is selected by default.}

\item{error_metric}{character. The error metric can be "mean" or "max". mean is selected by default}
}
\value{
A list that contains the hierarchical tesselation information. This
list has to be given as input argument to plot the tessellations.
\item{[[1]] }{List. Information about the tesselation co-ordinates - level
wise} \item{[[2]] }{List. Information about the polygon co-ordinates - level
wise} \item{[[3]] }{List. Information about the hierarchical vector
quantized data - level wise}
}
\description{
Main function to construct hierarchical voronoi tessellations.
}
\details{
This is the main function to construct hierarchical voronoi tessellations.
The \code{hvq} function is called from this function. The output of the
\code{hvq} function is hierarchical clustered data which will be the input
for constructing tessellations. The data is then represented in 2d
coordinates and the tessellations are plotted using these coordinates as
centroids. For subsequent levels, transformation is performed on the 2d
coordinates to get all the points within its parent tile. Tessellations are
plotted using these transformed points as centroids. The lines in the
tessellations are chopped in places so that they do not protrude outside the
parent polygon. This is done for all the subsequent levels.
}
\examples{
data(USArrests)
hvt.results <- list()
hvt.results <- HVT(USArrests, nclust = 15, depth = 1, quant.err = 0.2, 
                   distance_metric = "L1_Norm", error_metric = "mean",
                   projection.scale = 10, normalize = TRUE)
plotHVT(hvt.results, line.width = c(0.8), color.vec = c('#141B41'), 
        maxDepth = 1)

hvt.results <- list()
hvt.results <- HVT(USArrests, nclust = 3, depth = 3, quant.err = 0.2, 
                   distance_metric = "L1_Norm", error_metric = "mean",
                   projection.scale = 10, normalize = TRUE)
plotHVT(hvt.results, line.width = c(1.2,0.8,0.4), color.vec = c('#141B41','#0582CA','#8BA0B4'), 
        maxDepth = 3)
}
\seealso{
\code{\link{plotHVT}} \cr \code{\link{hvtHmap}}
}
\author{
Sangeet Moy Das <sangeet.das@mu-sigma.com>
}
\keyword{hplot}
