% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{condense.tags}
\alias{condense.tags}
\alias{condense.tags.data.frame}
\alias{condense.tags.mudata}
\title{Condense multiple columns to a single JSON column}
\usage{
condense.tags(x, ...)

\method{condense.tags}{data.frame}(x, tagcolumns, tagcolumn = "tags", ...)

\method{condense.tags}{mudata}(x, ...)
}
\arguments{
\item{x}{a data frame with tag columns}

\item{...}{passed to/from methods}

\item{tagcolumns}{column names to be condensed to JSON}

\item{tagcolumn}{the column in which to store JSON}
}
\value{
A modified data.frame
}
\description{
Performs the opposite of \link{expand.tags}: collapses the data in
\code{tagcolumns} to a single column (called \code{tagcolumn}) that contains
a JSON representation of the data that was previously in the tag columns
at that row.
}
\examples{
data(pocmaj)
condense.tags(pocmaj, tagcolumns = c("Ca", "Ti", "V"))

}
