% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtag.R
\name{wide}
\alias{wide}
\alias{wide.default}
\alias{wide.qtag.wide}
\alias{wide.qtag.long}
\title{Convert data to wide format}
\usage{
wide(x, ...)

\method{wide}{default}(x, ...)

\method{wide}{qtag.wide}(x, ...)

\method{wide}{qtag.long}(x, colvar, fun.aggregate, quiet = FALSE, ...)
}
\arguments{
\item{x}{A \link{qtag} object or one that can be coerced to one.}

\item{...}{Passed to other methods}

\item{colvar}{The column that contains the names of the to-be columns}

\item{fun.aggregate}{The aggregation function to be used if id.vars other than colvar
identify more than one row each.}

\item{quiet}{Supress warning messages on coersion to a qualifier/tag structure.}
}
\value{
A (possibly unchanged) \code{qtag.wide} data.frame
}
\description{
Convert data to wide format
}
\examples{
data(pocmaj)
pocmaj <- as.qtag(pocmaj, id.vars = c("core", "depth"))
pocmajlong <- long(pocmaj)
wide(pocmajlong)
wide(pocmaj)

}
