% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{long_pairs}
\alias{long_pairs}
\alias{long_biplot}
\alias{autobiplot}
\alias{autobiplot.data.frame}
\title{Biplot a parameter-long data frame}
\usage{
long_pairs(x, id_vars, name_var, names_x = NULL, names_y = NULL,
  validate = TRUE, max_names = 5)

long_biplot(x, id_vars, name_var, measure_var = "value", names_x = NULL,
  na.rm = FALSE, max_names = 5, ...)

autobiplot(x, ...)

\method{autobiplot}{data.frame}(x, id_vars, name_var, measure_var = "value",
  names_x = NULL, names_y = NULL, error_var = NULL, na.rm = TRUE,
  validate = TRUE, max_names = 5, labeller = ggplot2::label_value, ...)
}
\arguments{
\item{x}{the object to biplot}

\item{id_vars}{the columns that identify a single row in x}

\item{name_var}{The column where names_x and names_y are to be found}

\item{names_x}{The names to be included in the x axes, or all the names to be included}

\item{names_y}{The names to be included on the y axes, or NULL for all possible combinations
of \code{namesx}.}

\item{validate}{Ensure id_vars identify unique rows}

\item{max_names}{When guessing which parameters to biplot/pair, use only the first
max_names (or FALSE to use all names)}

\item{measure_var}{The column containing the values to plot}

\item{na.rm}{Should NA values in measure_var be removed?}

\item{...}{passed to \code{aes_string()}}

\item{error_var}{The column containing values for error bars (plus or minus error_var).}

\item{labeller}{The labeller to use to label facets (may want to use \code{label_parsed}
to use plotmath-style labels)}
}
\description{
Use either the ggplot framework (autobiplot) or base plotting to biplot a 
parameter-long data frame, like that of the data table in a \link{mudata} object.
}
\examples{
library(tidyr)
library(dplyr)

# create a long, summarised representation of pocmaj data
pocmaj_long <- pocmajsum \%>\%
  select(core, depth, Ca, Ti, V) \%>\%
  gather(Ca, Ti, V, key = "param", value = "value")

# biplot using base plotting
long_biplot(pocmaj_long, id_vars = c("core", "depth"), name_var = "param")

# biplot using ggplot
autobiplot(pocmaj_long, id_vars = c("core", "depth"), name_var = "param")

# get the raw data used
long_pairs(pocmaj_long, id_vars = c("core", "depth"), name_var = "param")

}
