% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_data.R
\name{data_validation}
\alias{data_validation}
\title{Represent validation causal data}
\usage{
data_validation(
  data,
  true_exposure,
  true_outcome,
  confounders = NULL,
  misclassified_exposure = NULL,
  misclassified_outcome = NULL,
  selection = NULL
)
}
\arguments{
\item{data}{Dataframe of validation data}

\item{true_exposure}{String name of the column in \code{data} corresponding to
the true exposure.}

\item{true_outcome}{String name of the column in \code{data} corresponding to
the true outcome.}

\item{confounders}{String name(s) of the column(s) in \code{data} corresponding
to the confounding variable(s).}

\item{misclassified_exposure}{String name of the column in \code{data}
corresponding to the misclassified exposure.}

\item{misclassified_outcome}{String name of the column in \code{data}
corresponding to the misclassified outcome.}

\item{selection}{String name of the column in \code{data} corresponding to the
selection indicator.}
}
\description{
\code{data_validation} is one of two different options to represent bias
assumptions for bias adjustment. It combines the validation dataframe
with specific identification of the appropriate columns for bias adjustment,
including: true exposure, true outcome, confounders, misclassified exposure,
misclassified outcome, and selection. The purpose of validation data is to
use an external data source to transport the necessary causal relationships
that are missing in the observed data.
}
\examples{
df <- data_validation(
  data = df_sel_source,
  true_exposure = "X",
  true_outcome = "Y",
  confounders = c("C1", "C2", "C3"),
  selection = "S"
)

}
