% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{pca}
\alias{pca}
\title{Principal Component Analysis - PCA}
\usage{
pca(X, scale = FALSE, ncomp = 1, ...)
}
\arguments{
\item{X}{\code{matrix} of input data.}

\item{scale}{\code{logical} indicating if variables should be standardised (default=FALSE).}

\item{ncomp}{\code{integer} number of principal components to return.}

\item{...}{additional arguments to \code{pls:pcr}.}
}
\value{
\code{multiblock} object with scores, loadings, mean X values and explained variances. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{pls::PCR} function for computing PCA.
}
\details{
PCA is a method for decomposing a matrix into subspace components with sample scores and
variable loadings. It can be formulated in various ways, but the standard formulation uses singular
value decomposition to create scores and loadings. PCA is guaranteed to be the optimal way of extracting
orthogonal subspaces from a matrix with regard to the amount of explained variance per component.
}
\examples{
data(potato)
X <- potato$Chemical

pca.pot  <- pca(X, ncomp = 2)

}
\references{
Pearson, K. (1901) On lines and planes of closest fit to points in space. Philosophical Magazine, 2, 559–572.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
