% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{residualDiagnostics.merMod}
\alias{residualDiagnostics.merMod}
\title{residualDiagnostics methods for merMod objects}
\usage{
\method{residualDiagnostics}{merMod}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  ...
)
}
\arguments{
\item{object}{An object with class \code{merMod}. Currently only
\code{lmer()} models are supported.}

\item{ev.perc}{The extreme value percentile to use. Defaults to
.001.}

\item{robust}{A logical value, whether to use robust estimates or not.
Defaults to \code{FALSE}.}

\item{distr}{A character string specifying the assumed distribution.
Currently \dQuote{normal}, but may expand in the future if
\code{glmer()} models are supported.}

\item{standardized}{A logical value whether to use standardized
residual values or not. Defaults to \code{TRUE}.}

\item{...}{Additional arguments. Not currently used.}
}
\value{
A logical (\code{is.residualDiagnostics}) or
  a residualDiagnostics object (list) for
  \code{as.residualDiagnostics} and \code{residualDiagnostics}.
}
\description{
residualDiagnostics methods for merMod objects
}
\examples{
library(JWileymisc)
sleep[1,1] <- NA
m <- lme4::lmer(extra ~ group + (1 | ID), data = sleep)

residualDiagnostics(m)$Residuals

#  gm1 <- lme4::glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
#    data = lme4::cbpp, family = binomial)
# residualDiagnostics(gm1) ## should be an error

rm(m, sleep)

}
