% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{ranef.brmcoda}
\alias{ranef.brmcoda}
\alias{ranef}
\title{Group-Level Estimates}
\usage{
\method{ranef}{brmcoda}(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link{ranef.brmsfit}}.}
}
\value{
A list of 3D arrays (one per grouping factor).
 If \code{summary} is \code{TRUE},
 the 1st dimension contains the factor levels,
 the 2nd dimension contains the summary statistics
 (see \code{\link[brms]{posterior_summary}}), and
 the 3rd dimension contains the group-level effects.
 If \code{summary} is \code{FALSE}, the 1st dimension contains
 the posterior draws, the 2nd dimension contains the factor levels,
 and the 3rd dimension contains the group-level effects.
}
\description{
Extract the group-level ('random') effects of each level
of the \code{brmsfit} object in a \code{brmcoda} object.
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  m <- brmcoda(compilr = compilr(data = mcompd, sbp = sbp,
                                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                                 idvar = "ID", total = 1440),
  formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
    wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")
  
  ## extract group-level coefficients
  ranef(m)
}}
}
\seealso{
\code{\link[brms:ranef.brmsfit]{ranef.brmsfit}}
}
