% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsubmargins.R
\name{wsubmargins}
\alias{wsubmargins}
\title{Within-person Average Substitution}
\usage{
wsubmargins(
  object,
  delta,
  basesub,
  ref = "clustermean",
  level = "within",
  weight = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object.}

\item{delta}{A integer, numeric value or vector indicating the amount of substituted change between compositional parts.}

\item{basesub}{A \code{data.frame} or \code{data.table} of the base possible substitution of compositional parts.
This data set can be computed using function \code{\link{basesub}}.
If \code{NULL}, all possible pairwise substitution of compositional parts are used.}

\item{ref}{Either a character value or vector or a dataset.
Can be \code{"grandmean"} and/or \code{"clustermean"}, or
a \code{data.frame} or \code{data.table} of user's specified reference grid consisting
of combinations of covariates over which predictions are made.
User's specified reference grid is only possible for simple substitution.}

\item{level}{A character string or vector.
Should the estimate be at the \code{"between"} and/or \code{"within"} level?}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.
If \code{"equal"}, give equal weight to units (e.g., individuals).
If \code{"proportional"}, weights in proportion to the frequencies of units being averaged
(e.g., observations across individuals)
Default is \code{equal}.}

\item{...}{Additional arguments passed to \code{\link{describe_posterior}}.}
}
\value{
A list containing the results of multilevel compositional substitution model.
The first four lists contain the results of the substitution estimation for a compositional part.
\item{\code{Mean}}{ Posterior means.}
\item{\code{CI_low} and \code{CI_high}}{ 95\% credible intervals.}
\item{\code{Delta}}{ Amount substituted across compositional parts.}
\item{\code{From}}{ Compositional part that is substituted from.}
\item{\code{To}}{ Compositional parts that is substituted to.}
\item{\code{Level}}{ Level where changes in composition takes place. Either \code{between} or \code{within}.}
\item{\code{Reference}}{ Either \code{grandmean}, \code{clustermean}, or \code{users}.}
}
\description{
This function is an alias of \code{\link{substitution}} to estimates the the difference in an outcome
when compositional parts are substituted for specific unit(s) at \emph{within} level
using cluster mean (e.g., compositional mean at individual level) as reference composition.
It is recommended that users run substitution model using the \code{\link{substitution}} function.
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){

cilr <- compilr(data = mcompd, sbp = sbp, 
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID", total = 1440)

# model with compositional predictor at between and within-person levels
m <- brmcoda(compilr = cilr, 
             formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 + 
                                wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID), 
             chain = 1, iter = 500,
             backend = "cmdstanr")
                     
subm <- wsubmargins(object = m, basesub = psub, delta = 5)
}}
}
\seealso{
\code{\link{substitution}}
}
