% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantize_color.R
\name{quantize_color}
\alias{quantize_color}
\title{Find a scale mod k that matches a given color}
\usage{
quantize_color(
  set,
  nmax = 12,
  reconvert = FALSE,
  ineqmat = NULL,
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{nmax}{Integer, essentially a limit to how far the function should search before giving up.
Although every real color should have a rational representation in some mod k universe, for some colors
that k must be very high. Increasing nmax makes the function run longer but might be necessary
if small chromatic universes don't produce a result. Defaults to \code{12}.}

\item{reconvert}{Boolean. Should the scale be converted to 12edo? Defaults to \code{FALSE}.}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "roth", "pastel," or "rosy", giving the
\code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}},
and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
If \code{reconvert=FALSE}, a list of two elements: element 1 is \code{set} with a vector of integers
representing the quantized scale; element 2 is \code{edo} representing the number k of unit steps in the
mod k universe. If \code{reconvert=TRUE}, returns a single numeric vector measured relative
to the unit step size input as \code{edo}: these generally will not be integers. May also return a vector
of \code{NA}s the same length as \code{set} if no suitable quantization was found beneath the limit given by
\code{nmax}.
}
\description{
Modal Color Theory is useful for analyzing scales in continuous pitch-class
space with irrational values, but sometimes those irrational values can be
inconvenient to work with. Therefore it's often quite useful to find a
scale that has the same color as the one you're studying, but which can
be represented by integers in some mod k universe. See "Modal Color Theory,"
27.
}
\examples{
qcm_fifth <- meantone_fifth()
qcm_lydian <- sort(((0:6)*qcm_fifth)\%\%12)
quantize_color(qcm_lydian)

# Let's approximate the Werckmeister III well-temperament
werck_ratios <- c(1, 256/243, 64*sqrt(2)/81, 32/27, (256/243)*2^(1/4), 4/3, 
  1024/729, (8/9)*2^(3/4), 128/81, (1024/729)*2^(1/4), 16/9, (128/81)*2^(1/4))
werck3 <- z(werck_ratios)
quantize_color(werck3)
quantize_color(werck3, reconvert=TRUE)

}
