% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets.R
\name{subset_varieties}
\alias{subset_varieties}
\title{Specific varieties of scalar subsets given a generic shape}
\usage{
subset_varieties(subsetdegrees, set, unique = TRUE, edo = 12, rounder = 10)
}
\arguments{
\item{subsetdegrees}{Vector of integers indicating the generic shape to use, e.g. \code{c(0, 2, 4)} for
tertian triads in a heptachord. Expected to begin with \code{0} and must have length > 1.}

\item{set}{The scale to find subsets of, as a numeric vector}

\item{unique}{Should each variety be listed only once? Defaults to \code{TRUE}. If \code{FALSE},
each specific variety will be listed corresponding to how many times it occurs as a subset.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A numeric matrix whose columns represent the specific varieties of the subset
}
\description{
Considered mod 7, the traditional triads of a diatonic scale are all instances of the generic
shape (0, 2, 4). They come in three varieties: major, minor, and diminished. This function lists
the distinct varieties of any similarly defined generic shape which occur as subsets in some
specified scale (or larger set).
}
\examples{
c_major_scale <- c(0, 2, 4, 5, 7, 9, 11)
double_harmonic_scale <- c(0, 1, 4, 5, 7, 8, 11)

subset_varieties(c(0, 2, 4), c_major_scale)
subset_varieties(c(0, 2, 4), c_major_scale, unique=FALSE)
subset_varieties(c(0, 2, 4), double_harmonic_scale)
}
