% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{alexaNMF}
\alias{alexaNMF}
\title{Perform Non-negative Matrix Factorization using Brunet's Algotithm.}
\usage{
alexaNMF(v, r, params)
}
\arguments{
\item{v}{numeric matrix of Mutation Type Counts}

\item{r}{numeric, number of signatures to extract}

\item{params}{list including all paramaters for running the analysis}
}
\value{
list including all paramaters for running the analysis:
\enumerate{
  \item \bold{W} extracted signatures
  \item \bold{H} contribution of each signature in all the samples of the input mut count matrix
}
}
\description{
Perform Non-negative Matrix Factorization.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\examples{
x <- mutSignatures:::getTestRunArgs("alexaNMF")
y <- mutSignatures:::alexaNMF(v = x$v, r = x$r, params = x$params)
y$w[1:5, ]

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
