/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.jhlir.call.RList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.MuTossControl;
import org.mutoss.Parameter;

public class Method {
    private static final Log logger = LogFactory.getLog(Method.class);
    protected String name;
    protected String label;
    protected String errorControl = null;
    protected String function;
    protected List<Parameter> parameters = new Vector<Parameter>();
    protected List<Parameter> input = new Vector<Parameter>();
    protected List<String> output;
    protected String info;

    public Method(String method) {
        this.name = method;
        MuTossControl.getR().eval(".MuTossMethod <- mutoss:::" + this.name + "()");
        this.label = MuTossControl.getR().eval(".MuTossMethod@label").asRChar().getData()[0];
        try {
            this.errorControl = MuTossControl.getR().eval(".MuTossMethod@errorControl").asRChar().getData()[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.info((Object)"This method does not specify the error control");
        }
        this.function = MuTossControl.getR().eval(".MuTossMethod@callFunction").asRChar().getData()[0];
        RList rParameters = MuTossControl.getR().eval(".MuTossMethod@parameters").asRList();
        for (int i = 0; i < rParameters.getLength(); ++i) {
            if (!(rParameters.get(i) instanceof RList)) {
                ErrorHandler.getInstance().makeErrDialog("Arguments must be of type list! Please write the author of " + method + ".", null, false);
            }
            this.parameters.add(new Parameter(rParameters.getName(i), (RList)rParameters.get(i)));
        }
        List<String> slots = Arrays.asList("data", "model", "statistic", "hypNames", "pValues", "adjPValues", "errorControl", "rejected", "qValues", "locFDR", "pi0", "confIntervals", "alpha", "k", "q");
        for (Parameter param : this.parameters) {
            if (!slots.contains(param.getName())) continue;
            this.input.add(param);
        }
        this.output = Arrays.asList(MuTossControl.getR().eval(".MuTossMethod@output").asRChar().getData());
        this.info = MuTossControl.getR().eval(".MuTossMethod@info").asRChar().getData()[0];
    }

    public boolean isApplicable() {
        logger.debug((Object)("Checking whether Method \"" + this.name + "\" is applicable."));
        for (Parameter i : this.input) {
            if (i.isOptional()) continue;
            if (i.getName().equals("pValues") && !MuTossControl.getObj().hasPValues()) {
                return false;
            }
            if (i.getName().equals("data") && !MuTossControl.getObj().hasData()) {
                return false;
            }
            if (i.getName().equals("model") && !MuTossControl.getObj().hasModel()) {
                return false;
            }
            if (i.getName().equals("adjPValues") && !MuTossControl.getObj().hasAdjPValues()) {
                return false;
            }
            if (!i.getName().equals("alpha") && !i.getName().equals("k") && !i.getName().equals("q") || MuTossControl.getObj().hasErrorRate()) continue;
            return false;
        }
        if (this.errorControl != null && MuTossControl.getObj().hasErrorRate() && !this.errorControl.equals(MuTossControl.getObj().getErrorControlType())) {
            return false;
        }
        if (MuTossControl.getR().eval("exists(\"" + this.name + ".model\")").asRLogical().getData()[0] && !MuTossControl.getR().eval("" + this.name + ".model(" + MuTossControl.getObj().getObjName() + "@model)").asRLogical().getData()[0]) {
            return false;
        }
        logger.debug((Object)("Method \"" + this.name + "\" is applicable"));
        return true;
    }

    public boolean returnsAdjPValues() {
        return this.output.contains("adjPValues");
    }

    public boolean returnsRejected() {
        return this.output.contains("rejected");
    }

    public boolean returnsPValues() {
        return this.output.contains("pValues");
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getErrorControl() {
        return this.errorControl;
    }

    public String getFunction() {
        return this.function;
    }

    public List<Parameter> getInput() {
        return this.input;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public String getInfo() {
        return this.info;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean returnsCI() {
        return this.output.contains("confIntervals");
    }
}

