/*
 * Decompiled with CFR 0.152.
 */
package junit;

import junit.MyTestCase;
import org.af.jhlir.call.RErrorException;
import org.af.jhlir.call.RObj;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class REngineServices_Test
extends MyTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testWarnings() {
        this.getRServices().evalVoid("warning(\"Warning!\")");
        String[] warning = this.getRServices().getWarning();
        Assert.assertEquals((Object)"Warning!", (Object)warning[0]);
    }

    @Test
    public void testErrors() {
        String error = "";
        try {
            this.getRServices().evalVoid("stop(\"error\")");
        }
        catch (RErrorException re) {
            error = re.getMessage();
        }
        Assert.assertTrue((boolean)error.endsWith("error\n"));
    }

    @Test(expected=RErrorException.class)
    public void testMissingBracket1() {
        this.getRServices().evalVoid("rnorm(100");
    }

    @Test(expected=RErrorException.class)
    public void testMissingBracket2() {
        this.getRServices().evalVoid("{rnorm(100)");
    }

    @Test(expected=RErrorException.class)
    public void testUnexpected() {
        this.getRServices().evalVoid("()");
    }

    @Test(expected=RErrorException.class)
    public void testUnknownObject() {
        this.getRServices().evalVoid("unknown()");
    }

    @Test(expected=RErrorException.class)
    public void testunusedArguments() {
        this.getRServices().evalVoid("rnorm(x=100)");
    }

    @Test(expected=RErrorException.class)
    public void testStop() {
        this.getRServices().evalVoid("stop(\"error\")");
    }

    @Test
    public void testCall() {
        RObj n = this.getRServices().eval("5");
        RObj mean = this.getRServices().eval("11");
        RObj sd = this.getRServices().eval("0.01");
        RObj result = null;
        System.out.println(n);
        System.out.println(mean);
        System.out.println(sd);
        result = this.getRServices().call("list", n, mean, sd);
    }
}

