/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.spi.wizard.SimpleWizard;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardControllerImplementation;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelProvider;

final class SimpleWizardInfo
implements WizardControllerImplementation {
    private WeakReference wizard = null;
    private final String[] descriptions;
    private final String[] steps;
    final int[] navModeByPanel;
    private String problem = null;
    private final String title;
    private final WizardPanelProvider provider;
    private boolean busy = false;
    final WizardController controller = new WizardController(this);
    private int currNavMode = 1;

    SimpleWizardInfo(WizardPanelProvider provider) {
        this(provider.title, provider.steps, provider.descriptions, provider);
    }

    protected SimpleWizardInfo(String title, String[] steps, String[] descriptions, WizardPanelProvider provider) {
        if (steps == null) {
            throw new NullPointerException("Null steps");
        }
        if (descriptions == null) {
            throw new NullPointerException("Null descriptions");
        }
        this.steps = steps;
        this.descriptions = descriptions;
        if (new HashSet<String>(Arrays.asList(steps)).size() < steps.length) {
            throw new IllegalArgumentException("Duplicate ID: " + Arrays.asList(steps));
        }
        if (descriptions.length != steps.length && steps.length != descriptions.length + 1 && !"_#UndeterminedStep".equals(steps[steps.length - 1])) {
            throw new IllegalArgumentException("Steps and descriptions array lengths not equal: " + Arrays.asList(steps) + ":" + Arrays.asList(descriptions));
        }
        this.navModeByPanel = new int[steps.length];
        Arrays.fill(this.navModeByPanel, -1);
        this.title = title;
        this.provider = provider;
    }

    final void setWizard(SimpleWizard wizard) {
        this.wizard = new WeakReference<SimpleWizard>(wizard);
    }

    final SimpleWizard getWizard() {
        return this.wizard != null ? (SimpleWizard)this.wizard.get() : null;
    }

    final SimpleWizard createWizard() {
        return new SimpleWizard(this);
    }

    protected JComponent createPanel(String id, Map settings) {
        try {
            JComponent result = this.provider.createPanel(this.controller, id, settings);
            if (result instanceof WizardPage) {
                ((WizardPage)result).setController(this.controller);
                ((WizardPage)result).setWizardDataMap(settings);
            }
            return result;
        }
        catch (RuntimeException re) {
            JTextArea jta = new JTextArea();
            jta.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.RED));
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream str = new PrintStream(buf);
            re.printStackTrace(str);
            jta.setText(new String(buf.toByteArray()));
            this.setProblem(re.getLocalizedMessage());
            return new JScrollPane(jta);
        }
    }

    protected Object finish(Map settings) throws WizardException {
        return this.provider.finish(settings);
    }

    public String getLongDescription(String id) {
        return this.provider.getLongDescription(id);
    }

    protected void recycleExistingPanel(String id, Map settings, JComponent panel) {
        this.provider.recycle(id, this.controller, settings, panel);
    }

    private int index() {
        SimpleWizard wizard = this.getWizard();
        if (wizard != null) {
            return wizard.currentStepIndex();
        }
        return 0;
    }

    public final void setBusy(boolean value) {
        if (value != this.busy) {
            this.busy = value;
            this.fire();
        }
    }

    public final void setProblem(String value) {
        this.problem = value;
        int idx = this.index();
        this.provider.setKnownProblem(this.problem, idx);
        this.fire();
    }

    public final void setForwardNavigationMode(int value) {
        switch (value) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(value));
            }
        }
        if (this.currNavMode != value) {
            this.currNavMode = value;
            this.fire();
        }
        this.navModeByPanel[this.index()] = value;
    }

    public final int getFwdNavMode() {
        return this.currNavMode;
    }

    final String getTitle() {
        return this.title;
    }

    final void update() {
        int idx = this.index();
        boolean change = this.navModeByPanel[idx] != -1 && this.currNavMode != this.navModeByPanel[idx];
        this.setProblem(this.provider.getKnownProblem(idx));
        int n = this.currNavMode = this.navModeByPanel[idx] == -1 ? 1 : this.navModeByPanel[idx];
        if (change) {
            this.fire();
        }
    }

    final void fire() {
        SimpleWizard wiz = this.getWizard();
        if (wiz != null) {
            this.getWizard().fireNavigability();
        }
    }

    final boolean isValid() {
        return this.getProblem() == null;
    }

    final boolean canFinish() {
        return this.isValid() && this.currNavMode != -1 && (this.currNavMode & 2) != 0;
    }

    final boolean canContinue() {
        return this.isValid() && (this.currNavMode == -1 || (this.currNavMode & 1) != 0);
    }

    String[] getDescriptions() {
        return this.descriptions;
    }

    String[] getSteps() {
        return this.steps;
    }

    boolean containsStep(String name) {
        for (int i = 0; i < this.steps.length; ++i) {
            String step = this.steps[i];
            if (!name.equals(step)) continue;
            return true;
        }
        return false;
    }

    final String getProblem() {
        return this.problem;
    }

    boolean isBusy() {
        return this.busy;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            SimpleWizardInfo info = (SimpleWizardInfo)o;
            if (info.descriptions == null || info.steps == null) {
                throw new RuntimeException("Invalid info object");
            }
            return Arrays.equals(info.descriptions, this.descriptions) && Arrays.equals(info.steps, this.steps) && info.title == this.title;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.steps.length; ++i) {
            result += this.steps[i].hashCode() * (i + 1) ^ 0x1F;
        }
        return result + (this.title == null ? 0 : this.title.hashCode());
    }

    boolean cancel(Map settings) {
        return this.provider.cancel(settings);
    }

    public String toString() {
        return "SimpleWizardInfo@" + System.identityHashCode(this) + " for " + this.provider;
    }
}

