% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvQuad.R
\name{quadrature}
\alias{quadrature}
\title{computes the approximated Integral}
\usage{
quadrature(f, grid = NULL, ...)
}
\arguments{
\item{f}{a function which takes the x-values as a (n x d) matrix as a first argument}

\item{grid}{a grid of type \code{NIGrid}}

\item{...}{further arguments for the function \code{f}}
}
\value{
The approximated value of the integral
}
\description{
\code{quadrature} computes the integral for a given function based on an NIGrid-object
}
\examples{
myGrid <- createNIGrid(dim=2, type="GLe", level=5)
rescale(myGrid, domain=rbind(c(-1,1),c(-1,1)))
plot(myGrid, col="blue")
myFun <- function(x){
   1 - x[,1]^2 * x[,2]^2
}
quadrature(myFun, myGrid)
}
\seealso{
\code{\link{createNIGrid}}, \code{\link[=rescale.NIGrid]{rescale}}
}

