% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plot.mvgam.R
\name{mcmc_plot.mvgam}
\alias{mcmc_plot.mvgam}
\title{MCMC plots of \pkg{mvgam} parameters, as implemented in \pkg{bayesplot}}
\usage{
\method{mcmc_plot}{mvgam}(
  object,
  type = "intervals",
  variable = NULL,
  regex = FALSE,
  use_alias = TRUE,
  ...
)
}
\arguments{
\item{object}{An \R object typically of class \code{brmsfit}}

\item{type}{The type of the plot.
Supported types are (as names) \code{hist}, \code{dens},
\code{hist_by_chain}, \code{dens_overlay},
\code{violin}, \code{intervals}, \code{areas},
\code{areas_ridges}, \code{combo}, \code{acf},
\code{acf_bar}, \code{trace}, \code{trace_highlight},
\code{scatter}, \code{hex}, \code{pairs}, \code{violin},
\code{rhat}, \code{rhat_hist}, \code{neff}, \code{neff_hist}
and \code{nuts_energy}.
For an overview on the various plot types see
\code{\link[bayesplot:MCMC-overview]{MCMC-overview}}.}

\item{variable}{Names of the variables (parameters) to plot, as given by a
character vector or a regular expression (if \code{regex = TRUE}). By
default, a hopefully not too large selection of variables is plotted.}

\item{regex}{Logical; Indicates whether \code{variable} should
be treated as regular expressions. Defaults to \code{FALSE}.}

\item{use_alias}{Logical. If more informative names for parameters are available
(i.e. for beta coefficients \code{b} or for smoothing parameters \code{rho}), replace the uninformative
names with the more informative alias. Defaults to \code{TRUE}}

\item{...}{Additional arguments passed to the plotting functions.
See \code{\link[bayesplot:MCMC-overview]{MCMC-overview}} for
more details.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object
that can be further customized using the \pkg{ggplot2} package.
}
\description{
Convenient way to call MCMC plotting functions
implemented in the \pkg{bayesplot} package for \pkg{mvgam} models
}
\examples{
\donttest{
simdat <- sim_mvgam(n_series = 1, trend_model = AR())
mod <- mvgam(y ~ s(season, bs = 'cc', k = 6),
             trend_model = AR(),
             noncentred = TRUE,
             data = simdat$data_train,
             chains = 2,
             silent = 2)
mcmc_plot(mod)
mcmc_plot(mod, type = 'neff_hist')
mcmc_plot(mod, variable = 'betas', type = 'areas')
mcmc_plot(mod, variable = 'trend_params', type = 'combo')
}
}
\seealso{
\code{\link{mvgam_draws}} for an overview of some of the shortcut strings
that can be used for argument \code{variable}
}
